package edu.cmu.cs.cs214.streamio;

import java.io.*;
import java.net.*;

public class TextSocketClient {

	/**
	 * @param args
	 * @throws IOException 
	 */
	public static void main(String[] args) throws IOException {
		if (args.length < 2) {
			System.err.println("usage: java edu.cmu.cs.cs214.streamio.TextSocketClient host port");
			System.exit(-1);
		}
		InetAddress host = InetAddress.getByName(args[0]);
		int port = Integer.parseInt(args[1]);
		
		Socket sock = new Socket(host, port);
		
		new TransferThread(sock.getInputStream(), System.out).start();
		new TransferThread(System.in, sock.getOutputStream()).start();
	}

}
